Vue.component('stat-card',{

    template: `
        <div class="gradient-border w-100 h-100">
            <div class="statsCard text-center sm-shadow h-100" :style="{
                backgroundImage: 'url(' + img + ')',
                backgroundRepeat: 'no-repeat',
                backgroundSize: 'contain', backgroundPosition: 'right -37px top 20px'
            }">
                <div class="card-body">
                    <h2 class="title">{{title}}</h2>
                    <div class="d-flex justify-content-center mt-2" v-if="loading">
                        <i class="fa-solid fa-circle-notch fa-spin" style="font-size: 3rem;"></i>
                    </div>
                    <h3 v-else class="value m-0">
                        {{value}}
                    </h3>
                </div>
            </div>
        </div>
    `,
    data() {
        return {
            title: 'Stat card'
        }
    },
        props:['img', 'loading', 'title', 'value'],
});
