Vue.component('home-sidebar',{
    template: /*html*/`

    <div class="sidebar pl-2 h-100" style="overflow-y: auto; max-height: 100vh;" @mouseenter="expandSidebar" @mouseleave="collapseSidebar">
        <ul id="home-sidebar" class="p-0 pt-5 mb-0 scrollable-menu">
            <a 
                @click="changeView(0)"
                class="nav-link" 
                :class="{'sidebar-active': view_now==0}"
            >
                <i :class="{'text-white': view_now==0}" class="fa fa-home"></i> 
                <span :class="{'text-white': view_now==0}">Dashboard</span>
            </a>
            <a 
                @click="changeView(6)"
                class="nav-link"
                :class="{'sidebar-active': view_now==6}" 
            >
                <i :class="{'text-white': view_now==6}" class="fa-solid fa-newspaper"></i>
                <span :class="{'text-white': view_now==6}">{{ texts.news }}</span> 
            </a>
            <a 
                @click="changeView(1)"
                class="nav-link" 
                :class="{'sidebar-active': view_now==1}"
            >
                <img src="../images/rocketbot_base_icon.svg" v-if="view_now!==1" alt="Suite" />
                <img src="../images/rocketbot_white_icon.svg" v-else alt="Suite" />
                <span :class="{'text-white': view_now==1}">Suite</span>
            </a>
            <a 
                @click="changeView(4)"
                class="nav-link" 
                :class="{'sidebar-active': view_now==4}"
            >
                <i :class="{'text-white': view_now==4}" class="fa fa-life-ring"></i> 
                <span :class="{'text-white': view_now==4}">{{ texts.help_docs }}</span>
            </a>
            <a 
                @click="changeView(2)"
                class="nav-link" 
                :class="{'sidebar-active': view_now==2}"
            >
                <i :class="{'text-white': view_now==2}" class="fa fa-cogs"></i> 
                <span :class="{'text-white': view_now==2}">{{ texts.config }}</span>
            </a>
            <a 
                @click="changeView(5)"
                class="nav-link"
                :class="{'sidebar-active': view_now==5,'text-danger':!licensed}" 
            >
                <i :class="{'text-white ': view_now==5,'text-danger ':!licensed && view_now !== 5}" class="far fa-file-alt"></i> 
                <span :class="{'text-white': view_now==5}">{{ texts.license }}</span> 
                <i class="icon-ripple fa fa-exclamation-triangle" :class="{
                    'text-danger': !licensed && view_now !== 5,
                    'text-white' : !licensed && view_now === 5
                }"  v-show="!licensed"></i>
            </a>
        </ul>
    </div>        
       

    `,
    data: function(){
        return {
        }
    },
    props:['texts', 'licensed', 'version' , 'view_now'],
    computed: {
      
    },
    mounted () {
    },
    methods: {
        changeView(i) {
            this.$emit('change-view', i)
        },
        expandSidebar() {
            this.$emit('expand-sidebar')
        },
        collapseSidebar() {
            this.$emit('collapse-sidebar')
        }
    }
})