Vue.component('home-news',{
    template: /*html*/`
        <div class="container-fluid mt-2">
            <div class="row">
                <div class="col-md-12 d-flex align-items-center justify-content-between">
                    <h2 class="m-0">
                        <i class="fa-solid fa-newspaper"></i> {{ texts.news }}
                    </h2>
                    <button class="btn btn-sm btnSecondaryBorderLight" @click="refreshData">
                        {{ texts.refresh }}
                    </button>
                </div>
            </div>
            <div class="row mt-3">
                <div class="col-md-12">
                    <div class="card bigCard m-shadow h-100">
                        <div class="card-body">
                            <div class="d-flex justify-content-center" v-if="loading">
                                <i class="fa-solid fa-circle-notch fa-spin" style="font-size: 48px;"></i>
                            </div>
                            <div v-else>
                                <template v-for = "n in news_placeholder">
                                    <div 
                                        v-if="n.status"
                                        class="col-sm-6 col-md-4 col-lg-3 mb-4"
                                    >
                                        <div class="card bigCard sm-shadow">
                                            <img 
                                                :src="'http://localhost:'+url_port+'/image/'+n.src" 
                                                style="border-top-left-radius: 10px !important; border-top-right-radius: 10px" 
                                                :alt="n.title"
                                            >
                                            <div class="card-body">
                                                <h5 class="card-title">{{n.title}}</h5>
                                                <p class="card-text">{{n.description}}</p>
                                                <a :href="n.url" target="_blank" class="btn btnSecondaryBorderLight btn-block">{{texts.learn_more}}</a>
                                            </div>
                                        </div>
                                    </div>
                                </template>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    `,
    data: function(){
        return {
        }
    },
    props: ['texts', 'news_placeholder', 'url_port', 'loading'],
    computed: {
      
    },
    mounted () {
    },
    methods: {
        openNews(n){
            window.open(n.url, '_blank');
        },
        refreshData() {
            this.$emit('refresh-data');
        }
    }
})