Vue.component('home-license',{
    template:  /*html*/`
 <div class="container-fluid mt-2">

    <div class="row">
        <div class="col">
            <h2 class="m-0 text-nowrap">
                <i class="fa fa-file-alt"></i> 
                <span>{{ texts.license }}</span> 
            </h2>
        </div>
    </div>

    <div class="row mt-3">
        <div class="col-md-12">
            <div class="card bigCard m-shadow h-100">
                <div class="card-header d-flex align-items-center justify-content-between">
                    <h3 class="m-0">
                        {{ texts.have_license }}
                        <span :class="{'text-success': licensed, 'text-danger': !licensed}">
                            {{ texts[licensed.toString()] }}
                        </span>
                    </h3> 
                </div> 

                <div class="card-body">
                    <div v-if="licensed && !changingLicense" class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th scope="col">{{ texts.production_license }}</th>
                                    <th scope="col">{{ texts.max_executions }}</th>
                                    <th scope="col">{{ texts.online_license }}</th>
                                    <th scope="col">{{ texts.license_version }}</th>
                                    <th>{{ texts.expires }}</th>
                                    <th class="token-col" scope="col">
                                        Token
                                        <i class="fas fa-copy pointer ml-2" @click="copyToken('copied-1')" id="copy-icon-1"></i>
                                        <i class="fas fa-check pointer ml-2 d-none" ref="copied-1"></i>
                                    </th>    
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>{{ setLicenseType() }}</td>
                                    <td>
                                        {{ test }}
                                    </td>
                                    <td>
                                        {{ licenseOnline }}
                                    </td>
                                    <td>
                                        v{{ version }}
                                    </td>
                                    <td>
                                        {{caduca}}
                                    </td>
                                    <td class="token-col">
                                        {{ serial }}
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div v-if="licensed" class="float-right">
                        <button @click="changingLicense = !changingLicense" class="btn btnInfoBorderLight">
                            {{ texts.change_license }}
                        </button>
                    </div>

                    <div v-if="!licensed || changingLicense">
                           
                        <div class="form-group mt-5">
                            <label class="form-label">
                                {{ texts.copy_token }}
                            </label> <a 
                                class="rocket-text" 
                                href="https://license.rocketbot.co/"
                                target="_blank"
                            >
                                {{ texts.here }}
                            </a>.
                            <div class="input-group">
                                
                                <input 
                                    class="form-control text-muted font-weight-bolder" 
                                    id="token"
                                    :value="serial" 
                                    readonly
                                >
                                <div class="input-group-append">
                                    <button 
                                        class="btn btnSecondaryBorderLight btn-copy"
                                        type="button" 
                                        id="copy-token"
                                        @click="copyToken('copied-2')"
                                    >
                                        <i class="fas fa-copy" id="copy-icon"></i>
                                        <i class="fas fa-check pointer ml-2 d-none" ref="copied-2"></i>
                                    </button>
                                </div>
                                
                            </div>
                            <small class="form-text text-muted">
                                {{ texts.token_installed }}
                            </small>
                        </div>

                        <div class="form-group mt-5">
                            <label class="form-label">
                                {{ texts.paste_license }}
                            </label>
                            
                            <textarea
                                v-model="newToken"
                                class="form-control" 
                                id="licencia"
                                :placeholder="texts.license_code"
                            ></textarea>
                            <small>
                                ({{ texts.if_not_email }} 
                                <a 
                                    class="rocket-text"
                                    href="https://license.rocketbot.co/"
                                    target="_blank"
                                >
                                    {{ texts.here }}</a>)
                            </small>
                        </div>
                        <button 
                            id="checkLicence" 
                            class="btn btnSuccessBorderLight float-right"
                            :disabled="checking"
                            @click="checkLicense()"
                        >
                            <i class="fa-solid fa-circle-notch fa-spin" v-show="checking"></i>
                            {{ texts.validate }}
                        </button>
                    </div>

                    
                </div>
            </div>
        </div>
    </div>
</div>
    `,
    data: function(){
        return {
            checking: false,
            newToken: '',
            toastMessage: '',
            toastVariant: '',
            changingLicense: false
        }
    },
    props: {
        texts: Object,
        licensed: String,
        caduca: String,
        isOnline: {
            type: Boolean,
            required: false,
            default: false
        },
        licenseMaxExecutions: String,
        test: String,
        production: String,
        serial: String,
        url_port: String,
        version: String
    },
    computed: {
      licenseOnline () {
        return this.isOnline ? this.texts.yes : this.texts.no
      }
    },
    mounted () {
    },
    methods: {
        setLicenseType () {
            const prod = (this.production === '0' || this.production === false) ? false : true
            return this.texts[prod.toString()] || ''
        },
        viewLic (){
            this.$emit('deslicense');
            //TODO: no entiendo este metodo
        },
        copyToken (refName){
            navigator.clipboard.writeText(this.serial)
            setTimeout(() => {
                this.$refs[refName].classList.add('d-none')
            }, 2000)
            this.$refs[refName].classList.remove('d-none')
        },
        checkLicense() {
            this.checking = true;
            fetch(`http://localhost:${this.url_port}/checkLicenseOK/${this.newToken}`)
                .then(response => response.json())
                .then(data => {
                    this.checking = false;
                    const toast = document.getElementById('liveToast');
                    if (data === true) {
                        this.toastMessage = this.texts.license_saved_successfully;
                        this.toastVariant = 'bg-success';
                        setTimeout(() => {
                            location.reload();
                        }, 2000);
                    } else {
                        this.toastMessage = this.texts.license_is_invalid;
                        this.toastVariant = 'bg-danger';
                    }
                    toast.classList.add(this.toastVariant);
                    toast.classList.add('show');
                    setTimeout(() => {
                        toast.classList.remove('show');
                    }, 5000);
                })
                .catch(error => {
                    this.checking = false;
                    const toast = document.getElementById('liveToast');
                    this.toastMessage = this.texts.license_validation_error;
                    this.toastVariant = 'bg-danger';
                    toast.classList.add(this.toastVariant);
                    toast.classList.add('show');
                    setTimeout(() => {
                        toast.classList.remove('show');
                    }, 5000);
                });
        }
    }
})