Vue.component('home-header',{
    template: /*html*/`
    <div class="header bg-rocketbot container-fluid">

        <div class="header-logo" id="logo">
            <div class="container-fluid pl-0">
                <div class="row">
                    <div class="col-md-12 d-flex">
                        <h1 class="text-white header-title d-inline-block m-0">
                            <img class="me-2 ps-2 py-2" alt="Rocketbot" src="./images/studio_white.svg">
                            Studio
                        </h1>
                        <span class="version_header text-white font-weight-light align-self-center ml-1" style="margin-top: 0.8rem;">by Rocketbot</span>
                    </div>
                </div>
            </div>
        </div>

        <span class="badge badge-light p-1 d-flex justify-content-center align-items-center">
            {{ texts.license_status }}: 
            <span class="ml-1" :class="'text-' + (licenseStatus?.variant)">
                {{ licenseStatus?.message }} 
            </span>
            <span class="badge badge-dark text-white pointer p-1 ml-1" @click="goToLicenseView">
                {{ texts.more_details }}
            </span>
        </span>

    </div>
    `,
    data: function(){
        return {
      
        }
    },
    props:['texts', 'licensed', 'production', 'caduca'],
    computed: {
        licenseStatus() {
            if (!this.licensed) {
                return {
                    variant: 'rocketbot',
                    message: this.texts.no_license_found
                }
            } else if (this.licenseExpiresInAMonth()) {
                return {
                    variant: 'warning',
                    message: this.texts.license_expires_soon
                }
            } else if (!this.production || this.production === '0' || this.production === false) {
                return {
                    variant: 'success',
                    message: this.texts.development
                }
            } else {
                return {
                    variant: 'success',
                    message: this.texts.production
                }
            }
        }
    },
    mounted () {

    },
    methods: {
        goToLicenseView() {
            this.$emit('go-to-license-view')
        },
        licenseExpiresInAMonth() {
            const checkDate = new Date();                
            const expirationDate = new Date(this.caduca);   

            const oneMonthBefore = new Date(expirationDate);
            oneMonthBefore.setMonth(oneMonthBefore.getMonth() - 1);

            return checkDate >= oneMonthBefore && checkDate < expirationDate;
        }
    }
})