Vue.component('home-documentation',{
    template: /*html*/`
     <div class="container-fluid mt-2">
        <div class="row">
            <div class="col-md-12 d-flex align-items-baseline">
                <h2 class="m-0">
                    <i class="fa fa-life-ring"></i> 
                    {{ texts.help_docs }}
                </h2>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-12">
                <div class="card bigCard m-shadow h-100">
                    <div class="card-header d-flex align-items-center justify-content-between">
                        <h3 class="title m-0">
                            {{ texts.documentation }} - {{texts.command_line}}
                        </h3>
                        <a
                            href="https://docs.rocketbot.com/"
                            target="_blank"
                            type="button"
                            class="btn btnSecondaryBorderLight"
                        >
                            {{ texts.view_all_docs }}
                        </a>
                    </div>
                    <div class="card-body">
                        <div class="d-flex justify-content-center" v-if="loading">
                            <i class="fa-solid fa-circle-notch fa-spin" style="font-size: 48px;"></i>
                        </div>
                        <div v-else class="table-responsive">
                            <table class="table table-striped table-responsive">
                                <thead>
                                    <tr>
                                        <th>
                                            {{ texts.option }}
                                        </th>
                                        <th 
                                        
                                        >
                                            {{ texts.description }}
                                        </th>
                                        <th>
                                            {{ texts.example }}
                                        </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr v-for="option in command_lines">
                                        <td>
                                            <b>{{ option.option }}</b>
                                        </td>
                                        <td>
                                            {{ option.description }}
                                        </td>
                                        <td>
                                            rocketbot.exe {{ option.example }}
                                        </td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    `,
    data: function(){
        return {
        }
    },
    props: ['texts', 'command_lines', 'loading'],
    computed: {
      
    },
    mounted () {
    },
    methods: {
     
    }
})