Vue.component('home-config',{
    template:  /*html*/`
     <div class="container-fluid mt-2">

        <div v-if="ready" class="row">
            <div class="col-md-12 d-flex align-items-center justify-content-between">
                <h2 class="m-0">
                    <i class="fa fa-cogs"></i>
                    {{texts.config}}
                </h2>
            </div>
        </div>


            <div v-if="ready" class="row mt-3">
                <div class="col-md-12">
                    <div class="card cardBase bigCard m-shadow">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-12 col-lg-6">
                                    <div class="row">
                                        <div class="col-12 mb-2">
                                            <label>
                                                <input 
                                                    type="checkbox" 
                                                    v-model="configClone.editor.close_modal_on_backdrop"
                                                    :true-value="'true'" 
                                                    :false-value="'false'"
                                                >
                                                <span>{{texts.close_modals_on_backdrop_click}}</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                  <div class="col-md-12 col-lg-6">
                                    <label>{{texts.port_develop}}</label>
                                    <div class="form-group">
                                        <input 
                                            class="form-control" 
                                            v-model="configClone.server.port"
                                        >
                                        <small 
                                            class="text-muted"
                                            v-html="texts.need_restart"
                                        />
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-12 col-lg-6">
                                    <label> 
                                        {{texts.language}}: 
                                        <b>{{selected_language | languageUppercase}}</b> 
                                    </label>
                                    <div class="form-group">
                                        <select 
                                            class="form-control" 
                                            v-model="configClone.editor.lang" 
                                        >
                                            <option v-for="item in languages" :value="item">{{item}}</option>
                                        </select>
                                    </div>
                                </div>

                                <div class="col-md-12 col-lg-6">
                                    <div class="form-group">
                                        <label>Logs</label>
                                        <div class="input-group">
                                            <input 
                                                class="form-control accept_vars" 
                                                placeholder="/logs"
                                                id="modal_archivos_file_name" 
                                                type="text"
                                                v-model="configClone.server.logs"
                                            >
                                            <div class="input-group-append">
                                                <button 
                                                    class="btn btn-outline-secondary" 
                                                    type="button"
                                                    :disable="loading"
                                                    @click="getFolder()"
                                                >
                                                    <i class="fa-solid fa-circle-notch fa-spin" v-show="loading"></i>
                                                    {{texts.search}}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="text-right mt-3">
                                <button 
                                    class="btn btnSuccessBorderLight"
                                    :disable="saving" 
                                    @click="saveConfig()"
                                >
                                    <i class="fa fa-save"></i> 
                                    {{texts.save}}
                                    <i class="fa-solid fa-circle-notch fa-spin" v-show="saving"></i>
                                </button>
                            </div>
                        </div>
                        
                    </div>
                </div>
            </div>
        </div>
    `,
    data: function(){
        return {
            configClone: {
                editor: {}
            },
            ready: false,
            loading: false,
            saving: false
        }
    },
    props: ['texts', 'selected_language', 'config', 'languages', 'url_port'],
    filters: {
        languageUppercase: function (value) {
            return value?.toUpperCase() || '';
        }
    },
    computed: {
      
    },
    mounted () {
        this.configClone = JSON.parse(JSON.stringify(this.config))
        this.ready = true
    },
    methods: {
        getFolder() {
            this.loading = true
            fetch(`http://localhost:${this.url_port}/getfolder`, {
                method: 'GET',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => {
                return response.text(); 
            })
            .then(data => {
                this.$set(this.configClone.server, 'logs', data || '');
            })
            .catch(error => {
                console.error('There was a problem with the fetch operation:', error);
            })
            .finally(() => {
                this.loading = false;
            });
        },
        saveConfig() {
            this.saving = true
            fetch(`http://localhost:${this.url_port}/setConfig`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `config=${JSON.stringify(this.configClone)}`
            })
            .then(response => {
                document.location.reload();
            })

          //TODO si cambio la ventana sin guardar el seteo del config vuelve al q estaba antes?
        }
    }
})