Vue.component('file-dropdown-menu',{
    template:  /*html*/`
           <div class="dropdown dropleft">
                <div 
                    class="btn" 
                    type="button" 
                    data-toggle="dropdown"
                    aria-expanded="false"
                    :ref="'dropdownButton' + index"
                >
                    <i class="fas fa-ellipsis-v"></i>
                </div>
                <ul class="dropdown-menu">
                    <li>
                        <span 
                            class="dropdown-item"
                            @click="loadFlow(file)"
                            >
                            <i class="fa fa-code-branch"></i> 
                            <span>{{texts.open_drawflow}}</span>
                        </span>
                    </li>
                    <div class="dropdown-divider"></div>
                    <li>
                        <span 
                            class="dropdown-item"
                            @click="loadCascade(file)"
                        >
                            <i class="fa fa-align-justify"></i> 
                            <span>{{texts.open_cascade}}</span>
                        </span>
                    </li>
                    <div class="dropdown-divider"></div>
                    <li>
                        <span 
                            class="dropdown-item"
                            @click="removeFile(file)"
                        >
                            <i class="fa-solid fa-ban"></i> 
                            <span>{{texts.delete_from_list}}</span>
                        </span>
                    </li>
                    <div class="dropdown-divider"></div>
                    <li>
                        <span 
                            class="dropdown-item text-danger"
                            @click="openDeleteConfirmation(file)"
                        >
                            <i class="fa fa-trash-alt"></i> 
                            <span>{{texts.delete}}</span>
                        </span>
                    </li>
                </ul>
            </div>
    `,
    props: ['texts', 'index','file', 'viewing'],
    methods: {
            loadFlow(file){
                window.location.href = '/flow?r=' + file.name + '&d=' + (this.viewing?.encode || file.encode);
            },
            loadCascade(file){
                window.location.href = '/editor/#/edit/' + file.name + '/db/' + (this.viewing?.encode || file.encode);
            },  
            removeFile(file){
                this.$emit('remove-file', file)
            },
            openDeleteConfirmation(file){
                this.$emit('open-delete-confirmation', file)
            }
    }
})
