const app = new Vue({
    el: '#app',
    data: {
        filter: 'month',
        files: [],
        viewing_mode: 'card',
        view_now: 0,
        languages: [],
        selected_language: 'en',
        config: {},
        new_bot_file: "robot.db",
        new_project_path: "",
        new_bot_encode: "",
        validBotName: true,
        iframe_lang: "es",
        author: "",
        updates: [],
        readme: "",
        licensed: true,
        url_port: '5000',
        close_modal_on_backdrop: true,
        license:null,
        projectPath: '',
        texts: {},
        version: '',
        production: null,
        caduca: null,
        serial: null,
        licenseIsOnline: false,
        licenseMaxExecutions: 0,
        db: '',
        loading: true,
        licenseLoaded: false,
        command_lines: [],
        file_bots: {
            bots: []
        },
        viewing: null,
        new_bot_name: null,
        new_bot_description: '',
        new_bot_type: 'studio',
        loadingProject: false,
        toastMessage: '',
        creatingProject: false,
        filteredBotsInDbSearchTerm: '',
        selectedFiles: [],
        databaseSelector: null,
        new_path: '',
        news_placeholder: [
          
        ],
        os: '',
        analytics: {},
        //last bots opened
        searchFileTermLastBots: '',
        robotToDelete: null,
        deletingRobot: false,
        deletingRobots: false,
        selectedDbs: [],
        searchDb: '',
        selectedFilesInDb: [],
        in_db: false,
        removingDb: false,
        fileToRemove: null,
        removingFile: false,
        removingFiles: false
        
    },
    watch: {
        filteredFiles (val) {
            this.selectedFiles = this.selectedFiles.filter(file => {
                return val.some(f => f.id === file.id && f.encode === file.encode)
            })
        },
        filteredBotsInDb (val) {
            const filteredBotsSet = new Set(val.map(file => file.id))
            this.selectedFilesInDb = this.selectedFilesInDb.filter(file => filteredBotsSet.has(file.id))
        },
        selectedFiles (val) {
            if (val.length === 0) {
                this.databaseSelector = null
                this.new_path = ''
            }
        },
        filteredDatabaseFiles (val) {
           this.selectedDbs = this.selectedDbs.filter(file => {
                return val.some(f => f.id === file.id)
            })
        }
    },
    computed: {
        //files inside a db
        filteredBotsInDb() {
            return this.file_bots.bots.filter(bot => {
                return bot.name.toLowerCase().includes(this.filteredBotsInDbSearchTerm.toLowerCase()) || 
                bot.created_at.toLowerCase().includes(this.filteredBotsInDbSearchTerm.toLowerCase()) ||
                bot.description.toLowerCase().includes(this.filteredBotsInDbSearchTerm.toLowerCase())
            });
        },
        noFilesInDbSelected() {
            return this.selectedFilesInDb.length === 0
        },
        someFilesInDbSelected() {
            return this.selectedFilesInDb.length > 0 && this.selectedFilesInDb.length < this.filteredBotsInDb.length
        },
        allFilesInDbSelected() {
            return this.selectedFilesInDb.length === this.filteredBotsInDb.length
        },
        //dbs list
        someDbsSelected() {
            //no tiene que contar las db sin id
            return this.selectedDbs.length > 0 && this.selectedDbs.length < this.filteredDatabaseFiles.filter(file => file.id).length
        },
        allDbsSelected() {
            //no tiene que contar las db sin id
            return this.selectedDbs.length === this.filteredDatabaseFiles.filter(file => file.id).length
        },     
        filteredDatabaseFiles () {
            return this.databaseFiles.filter(file => {
                return file.name.toLowerCase().includes(this.searchDb.toLowerCase()) ||
                file.path.toLowerCase().includes(this.searchDb.toLowerCase()) ||
                file.created_at.toLowerCase().includes(this.searchDb.toLowerCase())
            })
        },
        databaseFiles () {
            return this.files.filter(file => {
                return file.type === 'filedb'
            })
        },
        noSelectedDbs() {
            return this.selectedDbs.length === 0
        },
        //last opened files list
        someFilesSelected() {
            return this.selectedFiles.length > 0 && 
            this.selectedFiles.length < this.filteredFiles().length
        },
        allFilesSelected() {
            return this.selectedFiles.length === this.filteredFiles().length
        },
        robotFiles () {
            return this.files.filter(file => {
                return file.type === 'db' || 
                file.type === 'file' || 
                file.type === 'flow'
            })
        },
        noSelectedFiles () {
            return this.selectedFiles.length === 0
        },
        titleAccordingToFilter() {
            switch (this.filter) {
                case 'day':
                    return this.texts.today;
                case 'week':
                    return this.texts.this_week;
                case 'month':
                    return this.texts.this_month;
                case 'all_time':
                    return this.texts.all_time;
                default:
                    return this.texts.today;
            }
        },
        isValidBotName() {
            var format = /^[-a-zA-Z0-9@\.+_]+$/;
            return format.test(this.new_bot_name);
        },
        selectedRobotsNames () {
            if (this.in_db) {
                return this.selectedFilesInDb.map(file => file.name).join(', ')
            } else if (!this.removingDb) {
                return this.selectedFiles.map(file => file.name).join(', ')
            } else {
                return this.selectedDbs.map(file => file.name).join(', ')
            }
        },
    },
    mounted () {
        $('#modal_list_bots').on('hidden.bs.modal', () => {
            this.in_db = false
            this.selectedFilesInDb = []
        })
        $('#newRobotModal').on('hidden.bs.modal', () => {
            this.new_bot_name = null
            this.new_bot_description = ''
            this.new_bot_type = 'studio'
            this.new_bot_file = "robot.db"
        })
        $('#newProjectModal').on('hidden.bs.modal', () => {
           this.new_bot_name = null
           this.author = ''
           this.new_bot_description = ''
           this.new_project_path = this.config.projects?.path
        })
        $('#removeFileFromList').on('hidden.bs.modal', () => {
            this.fileToRemove = null
        })
        $('#removeMultipleFromList').on('hidden.bs.modal', () => {
            this.removingDb = false
        })
    },
    beforeDestroy () {
        $('#modal_list_bots').off()
        $('#deleteMultipleConfirmationModal').off()
        $('#newRobotModal').off()
    },
    created () {
        this.selected_language = this.getCookie('language')
        this.pageConfiguration()
    },
    methods: { 
        //database multiselect
    
        async pageConfiguration () {
            this.loading = true
            let loadingOverlay = document.getElementById('loading-overlay')
            loadingOverlay.classList.remove('d-none')
            this.url_port = this.getUrlPort()
            await this.getLicense()
            await this.getAndSetConfig()
            this.getViewingModeFromCookie()
            await this.getLanguages()
            await this.getCurrentLanguage()
            await this.getRobotData()
            await this.getAnalytics()
        },
        async getAnalytics() {
            await fetch(`http://localhost:${this.url_port}/analytics/counts`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/json' },
                body: JSON.stringify({'filter_by': this.filter}) // options de filter_by: "today"|"week"|"month"|"all_time"
            })
            .then(response => response.json())
            .then(data => {
             this.analytics = data || {}
            })
            .catch(error => {
                console.error('Error loading analytics')
            })
        },
        async getRobotData() {
            await this.getUpdates()
            await this.getFiles()
            await this.getNews()
            await this.getCommandLines()
            this.loading = false
        },
        getUrlPort() {
            const currentUrl = window.location.href
            const urlObj = new URL(currentUrl)
            return urlObj.port
        },
        async getLicense() {
            await fetch(`http://localhost:${this.url_port}/license`, {
                method: 'GET',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                this.production = data.production
                this.caduca = data.expire
                this.serial = data.serial
                this.licenseIsOnline = data.isOnline
                this.licenseMaxExecutions = data.max_executions
                this.licensed = data.licensed
                this.version = data.version
                this.os = data.os
                
                this.licenseLoaded = true
            })
            .catch(error => {
                console.error(error)
            })
        },
        async getAndSetConfig() {
            await fetch(`http://localhost:${this.url_port}/getConfig`, {
                method: 'GET',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                this.setupConfig(data)
            })
            .catch(error => {
                console.log(error)
            })
        },
        async getLanguages() {
            await fetch(`http://localhost:${this.url_port}/languages`, {
                method: 'GET',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                this.languages = [...new Set(data)];
            })
            .catch(error => {
                console.log(error)
            })
        },
        async getCurrentLanguage() {
            await fetch(`http://localhost:${this.url_port}/commands/texts/${this.selected_language}`, {
                method: 'GET',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                this.texts = data?.texts || {}
                let loadingOverlay = document.getElementById('loading-overlay')
                loadingOverlay.classList.add('d-none')
                let studioHome = document.getElementById('studio-home')
                studioHome.classList.remove('d-none')
                let footer = document.getElementById('dashboard-footer')
                footer.classList.remove('d-none')
                if (!this.licensed) {
                    this.view_now = 5
                }
            })
            .catch(error => {
                console.error(error)
            })
        },
        async getUpdates() {
            if (this.os !== 'Windows') {
                return
            }
            await fetch(`http://localhost:${this.url_port}/updates`, {
                method: 'GET',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                this.updates = data?.data?.components || [];
                const tmpReadme = data.data.readme;

                let converter = new showdown.Converter()
                
                this.readme = converter.makeHtml(tmpReadme);

                if (this.updates.length > 0) {
                    $('#updateModal').modal('show');
                }
            })
            .catch(error => {
                console.log(error)
            })
        }, 
        async getFiles () {
            await fetch(`http://localhost:${this.url_port}/getlastfiles`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                this.files = data?.files || [];
                this.db = data.db;
                this.new_bot_encode = data.db;
                
            })
            .catch(error => {
                console.log(error)
            })
        },
        async getNews() {
            await fetch(`http://localhost:${this.url_port}/news/${this.selected_language}`, {
                method: 'GET',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then((response) => {
                if (!response.ok) {
                    throw new Error('News could not be loaded');
                }
                return response.json()
            })
            .then(data => {
                this.news_placeholder = data || []
            })
            .catch(error => {
                this.setErrorToast(error)
            })
        },
        async getCommandLines() {
            await fetch(`http://localhost:${this.url_port}/args/${this.selected_language}`, {
                method: 'GET',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
              if (data.error) {
                console.error('Error loading helpers')
                return
              }
              this.command_lines = data
            })
            .catch(error => {
                console.error('Error loading helpers')
            })
        },
        setupConfig(config) {
            this.config = config
            this.initializeEditorSettings();
            this.initializeServerSettings();
            this.setIframeLanguage();
            this.setProjectPath();
        },
        initializeEditorSettings() {
            if (!this.config.editor) {
                this.$set(this.config, 'editor', {
                    theme: 'light',
                    lang: 'en',
                    close_modal_on_backdrop: true,
                    view_mode: 'card'
                })

            }
            this.selected_language = this.config.editor.lang || 'en'
            this.setCookie("language", this.selected_language.toLowerCase())
            this.close_modal_on_backdrop = this.config.editor?.close_modal_on_backdrop || true;
            this.close_modal_on_backdrop = this.close_modal_on_backdrop === 'false' ? false : true;
        },
        initializeServerSettings() {
            if (!this.config.server) {
                this.$set(this.config, 'server', {
                    port: 5000,
                    logs: '/logs'
                })
            } else if (!this.config.server.logs) {
                this.config.server.logs = '/logs'
            }
            this.url_port = this.config.server?.port || 5000
        },
        setIframeLanguage() {
            this.iframe_lang = this.selected_language.toLowerCase();
            if (this.selected_language === "pr") {
                this.iframe_lang = "en";
            }
        },
        setProjectPath() {
            this.new_project_path = this.config.projects?.path;
        }, 
        getCookie(cname) {
            let name = cname + "=";
            let ca = document.cookie.split(';');
            for (let i = 0; i < ca.length; i++) {
                let c = ca[i];
                while (c.charAt(0) == ' ') {
                    c = c.substring(1);
                }
                if (c.indexOf(name) == 0) {
                    return c.substring(name.length, c.length);
                }
            }
            return "";
        },
        setCookie(cname, cvalue, exdays) {
            let d = new Date();
            d.setTime(d.getTime() + (exdays * 24 * 60 * 60 * 1000));
            let expires = "expires=" + d.toUTCString();
            document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
        },

        updateAll() {
            fetch(`http://localhost:${this.url_port}/updates/all`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .catch(error => {
                console.log(error)
            })
        },
        loadCascade (file) {
            window.location.href = '/editor/#/edit/' + file.name + '/db/' + (this.viewing?.encode || file.encode);
        },
        loadFlow (file) {
            window.location.href = '/flow?r=' + file.name + '&d=' + ( this.viewing?.encode || file.encode);
        },
        removeFileConfirm(file) {
            this.fileToRemove = file;
            $('#removeFileFromList').modal('show');
        },
        removeFile (file) {
            this.removingFile = true;
            fetch(`http://localhost:${this.url_port}/removeLastFile`, {
                method: 'POST',
                body: new URLSearchParams({
                    id: file.id
                })
            })
            .then(response => 
                response.json()
            )
            .then((data) => {
                this.setSuccessToast(this.texts.file_removed)
                $('#removeFileFromList').modal('hide');
                this.loading = true
                this.files = data.files
                this.db = data.db
                this.fileToRemove = null
               
                this.loading = false
            })
            .catch(error => {
                this.setErrorToast(error)
            })
            .finally(() => {
                this.removingFile = false
            })
        },
        //en nuevo robot las dos opciones de nueva db hace lo mismo
        getDBFile (isNew) {
            fetch(`http://localhost:${this.url_port}/getdb_file`, {
                method: 'POST',
                body: new URLSearchParams({
                    new: isNew
                }),
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                this.new_bot_file = data.filename
                this.new_bot_encode = data.encode
                $("#newDBModal").modal('hide')
            })
        },
        getDB () {
            fetch(`http://localhost:${this.url_port}/getdb_file`, {
                method: 'POST',
                body: new URLSearchParams({
                    new: false
                }),
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                if (data.load) {
                    data.type = "filedb";
                    data.path = data.filename;
                    this.loadBot({data: data});
                }
            })
        },
        loadBot (e) {
            const data = e?.data || e
            const force_type = e.force_type
            this.db = data.path
            if (data.type == 'filedb') {
                this.viewing = data
                fetch(`http://localhost:${this.url_port}/getbots`, {
                    method: 'POST',
                    body: new URLSearchParams({
                        db: data.encode
                    }),
                    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
                }).then(response => response.json())
                .then(data => {
                    this.file_bots = data
                    $("#modal_list_bots").modal();
                })
            } else {
                if (force_type == 'db') {
                    window.location.href = '/editor/#/edit/' + data.name + '/' + data.type + '/' + data.encode;
                } else if (force_type == 'flow') {
                    window.location.href = '/flow?r=' + data.name + '&d=' + data.encode;
                } else {
                    if (data.type == 'flow') {
                        window.location.href = '/flow?r=' + data.name + '&d=' + data.encode;
                    } else {
                        window.location.href = '/editor/#/edit/' + data.name + '/' + data.type + '/' + data.encode;
                    }
                }
            } 
        },
        createBot () {
            if (!this.licensed) {
                window.location.href = "/"
                return
            }
            fetch(`http://localhost:${this.url_port}/addbot`, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded'
                },
                body: new URLSearchParams({
                    name: this.new_bot_name,
                    code: JSON.stringify(""),
                    description: this.new_bot_description,
                    db: this.new_bot_encode,
                    version: this.version,
                    father: ''
                })
            })
            .then(response => response.json())
            .then(data => {
                $("#newRobotModal").modal('hide')
                const url = this.new_bot_type === 'flow' ? `flow?r=${this.new_bot_name}&d=${this.new_bot_encode}` : `editor/#/edit/${this.new_bot_name}/db/${this.new_bot_encode}`
                window.location.href = url;
            })
        }, 
        getProject () {
            this.loadingProject = true
            fetch(`http://localhost:${this.url_port}/getfolder`, {
                method: 'GET',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.text())
            .then(data => {
                this.new_project_path = data
                this.loadingProject = false
            })
            
        },
        createProject () {
            if (!this.licensed) {
                window.location.href = "/"
                return
            }
            this.creatingProject = true
            fetch(`http://localhost:${this.url_port}/createnewproject`, {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: new URLSearchParams({
                    name: this.new_bot_name,
                    path: this.new_project_path,
                    description: this.new_bot_description,
                    author: this.author
                })
            })
            .then(response => response.json())
            .then(data => {
                if (!data.data) {
                    this.setErrorToast(data.message)
                } else {
                    window.location.href = '/editor/#/edit/' + this.new_bot_name + '/db/' + data.data.db_path;
                }
               this.creatingProject = false
            })
        },
        setErrorToast (message) {
            const toast = document.getElementById('projectToast');
            this.toastMessage = message
            toast.classList.add('show');
            setTimeout(() => {
                toast.classList.remove('show');
            }, 5000);
        },
        setSuccessToast (message) {
            const toast = document.getElementById('successToast');
            this.toastMessage = message
            toast.classList.add('show');
            setTimeout(() => {
                toast.classList.remove('show');
            }, 5000);
        },
        selectFilesInDbAtOnce() {
            if(this.noFilesInDbSelected) {
              this.selectAllFilesInDb()
            } else {
             this.deselectAllFilesInDb()
            }
        },
        selectAllFilesInDb() {
            this.selectedFilesInDb = this.filteredBotsInDb
        },
        deselectAllFilesInDb() {
            this.selectedFilesInDb = []
        },
        selectFilesAtOnce() {
            if(this.noSelectedFiles) {
              this.selectAllFiles()
            } else {
             this.deselectAllFiles()
            }
        },   
        selectAllFiles() {
            this.selectedFiles = this.filteredFiles()
        },
        deselectAllFiles() {
            this.selectedFiles = []
        },
        deselectAllDBs() {
            this.selectedDbs = []
        },
        async openDeleteMultitpleConfirmation(in_db = false) {
            this.in_db = in_db
            let modal = document.getElementById('deleteMultipleConfirmationModal')
            if (modal) {
                $(modal).modal('show')
            }      
        },
        deleteSelectedRobots () {
            this.deletingRobots = true
            this.databaseSelector = null
            this.new_path = ''
            fetch(`http://localhost:${this.url_port}/deleterobotsfromdb`, {
                method: 'POST',
                body: JSON.stringify({
                    robots: this.in_db ? this.selectedFilesInDb : this.selectedFiles
                }),
                headers: {
                    'Content-Type': 'application/json'
                }
            })
          .then((response) => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                response.json()
            })
              .then(async data => {
                let modal = document.getElementById('deleteMultipleConfirmationModal')
                
                if (modal) {
                    $(modal).modal('hide')
                }
                this.setSuccessToast(this.texts.file_deleted)
                this.loading = true
                this.selectedFiles = []
                if (this.in_db) {
                    this.rechargeBotsInDb()
                } else {
                    await this.getFiles()
                }
            })
            .catch(error => {
                this.setErrorToast(error)
            }).finally(() => {
                this.deletingRobots = false
                this.loading = false
                this.in_db = false
            });
        },
        removeSelectedFilesConfirmation(files, removing_db = false) {
            $('#removeMultipleFromList').modal('show')
            this.filesToRemove = files
            this.removingDb = removing_db
        },
           removeSelectedFiles(files) {
            this.databaseSelector = null
            this.new_path = ''
            fetch(`http://localhost:${this.url_port}/removefilesfromlist`, {
                method: 'POST',
                body: JSON.stringify({ robots: files }),
                headers: {
                    'Content-Type': 'application/json'
                }
            })
            .then(async (response) => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                $('#removeMultipleFromList').modal('hide')
                this.setSuccessToast(this.texts.files_removed)
                this.loading = true
                await this.getFiles()
                this.loading = false
                this.selectedFiles = []

            })
            .catch(err => {
                this.setErrorToast(err?.message || 'Error removing files', 'bg-danger')
            })
        },
        manageRobots(type) {
            fetch(`http://localhost:${this.url_port}/getdb_file`, {
                method: 'POST',
                body: new URLSearchParams({
                    new: false
                }),
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                this.new_path = data.filename
                fetch(`http://localhost:${this.url_port}/managerobots`, {
                    method: 'POST',
                    body: JSON.stringify({
                        robots: this.selectedFiles,
                        type,
                        new_path: this.new_path
                    }),
                    headers: { 'Content-Type': 'application/json' }
                })
                 .then((response) => {
                    if (!response.ok) {
                        throw new Error('Network response was not ok')
                    }
                    response.json()
                })
                .then(async data => {
                  
                    this.new_path = ''
                    this.databaseSelector = null
                   this.setSuccessToast(type === 'move' ? this.texts.robot_moved_to_database : this.texts.robot_copied_to_database)
                    this.loading = true
                    await this.getFiles()
                    this.loading = false
                })
                .catch(err => {
                    this.setErrorToast(err)
                })
            })
            .catch(err => {
                this.setErrorToast(err)
            })
        },
        openDeleteConfirmation(file, index, in_db) {
            this.robotToDelete = file
            this.in_db = in_db
            let modal = document.getElementById('deleteConfirmationModal')
            if (modal) {
                $(modal).modal('show')
            }
         
        },
        deleteSingleRobot () {
            this.deletingRobot = true
            this.databaseSelector = null
            this.new_path = ''
            const formData = new FormData()
            formData.append('name', this.robotToDelete.name)
            formData.append('id', this.robotToDelete.id)
            formData.append('type', 'robot')
            formData.append('db', this.robotToDelete?.encode || this.robotToDelete.db_path)
            fetch(`http://localhost:${this.url_port}/removebot`, {
                method: 'POST',
                body: formData
            })
            .then((response) => {
                if (!response.ok) {
                    throw new Error('Network response was not ok');
                }
                response.text()
            })
            .then(async data => {
                let modal = document.getElementById('deleteConfirmationModal')
                if (modal) {
                    $(modal).modal('hide')
                }
                this.setSuccessToast(this.texts.file_deleted)
                this.loading = true
                if (this.in_db) {
                    //from file_bots remove the robot with id this.robotToDelete.id
                    this.file_bots.bots = this.file_bots.bots.filter(robot => robot.id !== this.robotToDelete.id)
                } else {
                    this.removeFile(this.robotToDelete)
                }
                this.robotToDelete = null
            })
            .catch(error => {
                this.setErrorToast(error)
            }).finally(() => {
                this.deletingRobot = false
                this.loading = false
            });
        },
        rechargeBotsInDb() {
            fetch(`http://localhost:${this.url_port}/getbots`, {
                method: 'POST',
                body: new URLSearchParams({
                    db: this.viewing.encode
                }),
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            }).then(response => response.json())
            .then(data => {
                this.file_bots = data
            })
        },
        deleteRobot(file) {
            const formData = new FormData()
            formData.append('name', file.name)
            formData.append('id', file.id)
            formData.append('type', 'robot')
            formData.append('db', file?.encode || file.db_path)
            fetch(`http://localhost:${this.url_port}/removebot`, {
                method: 'POST',
                body: formData
            })
            .then(response => response.text())
            .then(data => {
                this.removeFile(file)
            })
        },
        handleRightClick (index) {
            const dropdownButton = this.$refs['dropdownButton' + index]
            if (dropdownButton && dropdownButton[0]) {
                dropdownButton[0].click()
            }
        },
      
        setManageRobots(type) {
            fetch(`http://localhost:${this.url_port}/getdb_file`, {
                method: 'POST',
                body: new URLSearchParams({
                    new: false
                }),
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
            })
            .then(response => response.json())
            .then(data => {
                this.new_path = data.filename
                fetch(`http://localhost:${this.url_port}/managerobots`, {
                    method: 'POST',
                    body: JSON.stringify({
                        robots: this.selectedFilesInDb,
                        type,
                        new_path: this.new_path
                    }),
                    headers: {
                        'Content-Type': 'application/json'
                    }
                })
                .then(response => response.json())
                .then(data => {
                    this.new_path = ''
                    this.databaseSelector = null
                    this.setSuccessToast(type === 'move' ? this.texts.robot_moved_to_database : this.texts.robot_copied_to_database)
                    this.rechargeBotsInDb()
                })
            })
        },
        collapseSidebar() {
            const menu = document.querySelector('.menu');
            if (menu) {
                menu.classList.add('collapsed');
                menu.classList.remove('expanded');
            }
        },
        expandSidebar() {
            const menu = document.querySelector('.menu');
            if (menu) {
                menu.classList.add('expanded');
                menu.classList.remove('collapsed');
            }
        },
        dbIsSelected (id) {
            return this.selectedDbs.some(db =>  db.id === id)
        },
        selectDBsAtOnce() {
            if(this.noSelectedDbs) {
                this.selectAllDBs()
            } else {
                this.deselectAllDBs()
            }
        },
        selectAllDBs() {
            //si alguna db de filteredDatabaseFiles no tiene id, no la tiene que agregar a la seleccion
            this.selectedDbs = this.filteredDatabaseFiles.filter(file => file.id)
        },
        //last files opened list
        selectAllCascade() {
            this.selectedFiles = this.filteredFiles().filter(file => file.type === 'db')
        },
        selectAllDrawflow() {
            this.selectedFiles = this.filteredFiles().filter(file => file.type === 'flow')
        },
        selectAllFiles() { //selects all 
            this.selectedFiles = this.filteredFiles()
        },
        fileIsSelected (id, encode) {
            return this.selectedFiles.some(file => file.id === id && file.encode === encode)
        },
        fileInDbIsSelected (id, encode) {
            return this.selectedFilesInDb.some(file => file.id === id && file.encode === encode)
        },
        filteredFiles() {
            return this.robotFiles.filter(file => {
                return file.name.toLowerCase().includes(this.searchFileTermLastBots.toLowerCase()) || 
                file.path.toLowerCase().includes(this.searchFileTermLastBots.toLowerCase()) ||
                file.created_at.toLowerCase().includes(this.searchFileTermLastBots.toLowerCase())
            })
        },
        openModal (modal){
            $(modal).modal('show')
        },
        changeFilter (filter) {
            this.filter = filter
            this.refreshData()
        },
        async refreshData() {
            this.loading = true
            this.licenseLoaded = false
            await this.getRobotData()
            await this.getAnalytics()
        },
        truncateText (string, length) {
            if (string.length > length) {
                return string.substring(0, length) + '...';
            }
            return string;
        },
        getViewingModeFromCookie() {
            const viewingMode = this.getCookie('viewing_mode');
            if (viewingMode) {
                this.viewing_mode = viewingMode;
            } else {
                this.viewing_mode = this.config.editor?.view_mode || 'card';
            }
        },
        setCookieViewingMode(mode) {
            this.setCookie('viewing_mode', mode, 365);
            this.viewing_mode = mode;
        }
    }
});
