# Rocketbot Studio Updates Documentation

Welcome to the release notes for Rocketbot Studio PATCH 2025.10.13. Below you'll find a comprehensive set of updates that have been implemented recently. These modifications are geared to enhance functionality, address issues, and upgrade existing features within our software.

CHANGELOG: [CHANGELOG.md](CHANGELOG.md)

## Changes & Fixes

- **Core**
  - **Driverupdater**: Fixed EdgeDriver download, now downloads the driver correctly.
  - **Addon**: Fixed the Orchestrator Addon error that did not allow exporting and uploading of databases from Studio
  - **Addon**: Fixed a bug that prevented addons from loading after saving the robot
  - **Framework**: Fixed duplication bugs on the Framework transaction command, which prevented its correct usage.
  - **Editor**: Fixed an error 500 occurring when opening the editor after executed some critical scripts in the robot.
  - **Analytics**: New endpoints and metrics added to show more detailed information about robot executions and performance.
  - **Arguments**: Added new argument `--update-modules` to facilitate updating modules from the command line before the robot execution.


- **Studio view**
  - **UX/UI redesign**: Updated the visual design of the Studio interface for improved user experience.
  - **Try-Catch block**: Fixed a bug that prevented the second command in the catch block from executing.
  - **Set Multiple Vars**: Fixed an issue where the value name was not consistent.
  - **Robot weight**: Now the full version size of each robot can be seen.
  - **Integration menu**: Fixed a translation error on the Integration menu commands.
  - **Addon Inspector**: Changed some visuals to align with the new Studio design. 
  - **Modals**: Updated the size of several module modals to improve usability.

## Known Issues

- **Dependency Conflicts**: Occasionally, updates to external libraries might cause temporary compatibility issues with existing projects until adjustments are made in the project configuration.



## Compatibility Notice

- Please note that robots developed or modified with this update may not be compatible with previous versions of Rocketbot Studio. We recommend using the same version in both development and production environments. If the robot was developed in a different version, test its functionality thoroughly in the development environment before updating the production environment.


---

We advise all users to update to the latest version to take advantage of these improvements while developing. Stay tuned for further enhancements as we strive to make Rocketbot Studio even more robust and user-friendly. Thank you for choosing Rocketbot for your automation needs.